<?php
/**
 * Background Pattern Style - Polka Dots.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Polka_Dots
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Polka_Dots extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Polka Dots', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M0,8V0H8A8,8,0,0,1,0,8ZM80,8V0H72A8,8,0,0,0,80,8ZM0,72v8H8A8,8,0,0,0,0,72ZM40,32a8,8,0,1,0,8,8A8,8,0,0,0,40,32ZM80,72a8,8,0,0,0-8,8h8Z"/>',
				'default-inverted' => '<path d="M80,72V8a8,8,0,0,1-8-8H8A8,8,0,0,1,0,8V72a8,8,0,0,1,8,8H72A8,8,0,0,1,80,72ZM40,48a8,8,0,1,1,8-8A8,8,0,0,1,40,48Z"/>',
				'rotated'          => '<path d="M0,8V0H8A8,8,0,0,1,0,8ZM80,8V0H72A8,8,0,0,0,80,8ZM0,72v8H8A8,8,0,0,0,0,72ZM40,32a8,8,0,1,0,8,8A8,8,0,0,0,40,32ZM80,72a8,8,0,0,0-8,8h8Z"/>',
				'rotated-inverted' => '<path d="M80,72V8a8,8,0,0,1-8-8H8A8,8,0,0,1,0,8V72a8,8,0,0,1,8,8H72A8,8,0,0,1,80,72ZM40,48a8,8,0,1,1,8-8A8,8,0,0,1,40,48Z"/>',
				'thumbnail'        => '<path d="M0,0H1.6A1.6,1.6,0,0,1,0,1.6ZM14.4,0A1.6,1.6,0,0,0,16,1.6,1.6,1.6,0,0,0,17.6,0H14.4ZM0,14.4v3.2A1.6,1.6,0,0,0,1.6,16,1.6,1.6,0,0,0,0,14.4Zm8-8A1.6,1.6,0,1,0,9.6,8,1.6,1.6,0,0,0,8,6.4ZM30.4,0A1.6,1.6,0,0,0,32,1.6,1.6,1.6,0,0,0,33.6,0H30.4ZM16,14.4A1.6,1.6,0,1,0,17.6,16,1.6,1.6,0,0,0,16,14.4Zm8-8A1.6,1.6,0,1,0,25.6,8,1.6,1.6,0,0,0,24,6.4ZM46.4,0A1.6,1.6,0,0,0,48,1.6,1.6,1.6,0,0,0,49.6,0H46.4ZM32,14.4A1.6,1.6,0,1,0,33.6,16,1.6,1.6,0,0,0,32,14.4Zm8-8A1.6,1.6,0,1,0,41.6,8,1.6,1.6,0,0,0,40,6.4ZM62.4,0A1.6,1.6,0,0,0,64,1.6,1.6,1.6,0,0,0,65.6,0H62.4ZM48,14.4A1.6,1.6,0,1,0,49.6,16,1.6,1.6,0,0,0,48,14.4Zm8-8A1.6,1.6,0,1,0,57.6,8,1.6,1.6,0,0,0,56,6.4ZM78.4,0A1.6,1.6,0,0,0,80,1.6V0ZM64,14.4A1.6,1.6,0,1,0,65.6,16,1.6,1.6,0,0,0,64,14.4Zm8-8A1.6,1.6,0,1,0,73.6,8,1.6,1.6,0,0,0,72,6.4ZM78.4,16A1.6,1.6,0,0,0,80,17.6V14.4A1.6,1.6,0,0,0,78.4,16ZM0,30.4v3.2A1.6,1.6,0,0,0,1.6,32,1.6,1.6,0,0,0,0,30.4Zm8-8A1.6,1.6,0,1,0,9.6,24,1.6,1.6,0,0,0,8,22.4Zm8,8A1.6,1.6,0,1,0,17.6,32,1.6,1.6,0,0,0,16,30.4Zm8-8A1.6,1.6,0,1,0,25.6,24,1.6,1.6,0,0,0,24,22.4Zm8,8A1.6,1.6,0,1,0,33.6,32,1.6,1.6,0,0,0,32,30.4Zm8-8A1.6,1.6,0,1,0,41.6,24,1.6,1.6,0,0,0,40,22.4Zm8,8A1.6,1.6,0,1,0,49.6,32,1.6,1.6,0,0,0,48,30.4Zm8-8A1.6,1.6,0,1,0,57.6,24,1.6,1.6,0,0,0,56,22.4Zm8,8A1.6,1.6,0,1,0,65.6,32,1.6,1.6,0,0,0,64,30.4Zm8-8A1.6,1.6,0,1,0,73.6,24,1.6,1.6,0,0,0,72,22.4ZM78.4,32A1.6,1.6,0,0,0,80,33.6V30.4A1.6,1.6,0,0,0,78.4,32ZM0,46.4v3.2A1.6,1.6,0,0,0,1.6,48,1.6,1.6,0,0,0,0,46.4Zm8-8A1.6,1.6,0,1,0,9.6,40,1.6,1.6,0,0,0,8,38.4Zm8,8A1.6,1.6,0,1,0,17.6,48,1.6,1.6,0,0,0,16,46.4Zm8-8A1.6,1.6,0,1,0,25.6,40,1.6,1.6,0,0,0,24,38.4Zm8,8A1.6,1.6,0,1,0,33.6,48,1.6,1.6,0,0,0,32,46.4Zm8-8A1.6,1.6,0,1,0,41.6,40,1.6,1.6,0,0,0,40,38.4Zm8,8A1.6,1.6,0,1,0,49.6,48,1.6,1.6,0,0,0,48,46.4Zm8-8A1.6,1.6,0,1,0,57.6,40,1.6,1.6,0,0,0,56,38.4Zm8,8A1.6,1.6,0,1,0,65.6,48,1.6,1.6,0,0,0,64,46.4Zm8-8A1.6,1.6,0,1,0,73.6,40,1.6,1.6,0,0,0,72,38.4ZM78.4,48A1.6,1.6,0,0,0,80,49.6V46.4A1.6,1.6,0,0,0,78.4,48ZM8,54.4A1.6,1.6,0,1,0,9.6,56,1.6,1.6,0,0,0,8,54.4Zm16,0A1.6,1.6,0,1,0,25.6,56,1.6,1.6,0,0,0,24,54.4Zm16,0A1.6,1.6,0,1,0,41.6,56,1.6,1.6,0,0,0,40,54.4Zm16,0A1.6,1.6,0,1,0,57.6,56,1.6,1.6,0,0,0,56,54.4Zm16,0A1.6,1.6,0,1,0,73.6,56,1.6,1.6,0,0,0,72,54.4Z"/>',
			),
			'width'      => '80px',
			'height'     => '80px',
		);
	}
}

return new ET_Builder_Pattern_Polka_Dots();
