<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly. ?>

<h2>
	<?php _e( 'What personal data we collect and why we collect it', 'ultimate-member' ); ?>
</h2>
<h3>
	<?php _e( 'Forms', 'ultimate-member' ); ?>
</h3>
<p>
	<?php
	// translators: %s: plugin name.
	echo wp_kses( sprintf( __( '%s provides you with forms for user registration, login and profiles.', 'ultimate-member' ), UM_PLUGIN_NAME ), UM()->get_allowed_html( 'admin_notice' ) );
	?>
</p>
<p>
	<?php _e( 'Via these forms you are collecting personal data from your users.', 'ultimate-member' ); ?>
</p>
<p>
	<?php _e( 'You should include in your privacy policy what personal data is captured when someone submits/fills in one of the forms, why you collect it and what you do with this data and how long you keep it.', 'ultimate-member' ); ?>
</p>

<h2>
	<?php _e( 'How long we retain your data', 'ultimate-member' ); ?>
</h2>
<p>
	<?php _e( 'Registered user information is retained in your website’s database indefinitely.', 'ultimate-member' ); ?>
</p>
<p>
	<?php _e( 'Data can be exported or removed upon users request via the existing WordPress data exporter or eraser.', 'ultimate-member' ); ?>
</p>
<p>
	<?php _e( 'If syncing data to a 3rd party service (e.g Mailchimp via our MailChimp extension), data is retained there until unsubscribed or deleted.', 'ultimate-member' ); ?>
</p>

<h2>
	<?php _e( 'Where we send your data', 'ultimate-member' ); ?>
</h2>
<p>
	<?php
	// translators: %s: plugin name.
	echo wp_kses( sprintf( __( '%s does not send any user data outside of your site by default.', 'ultimate-member' ), UM_PLUGIN_NAME ), UM()->get_allowed_html( 'admin_notice' ) );
	?>
</p>
<p>
	<?php _e( 'If you have extended the functionality of the plugin (e.g sending registered user data to MailChimp via our MailChimp extension, this user info may be passed to these external services. These services may be located abroad and outwith the EU.', 'ultimate-member' ); ?>
</p>
